import { StarXpandCommand } from "star-io10-web";

export class LabelSample15_For203dpiAnd300dpi_FoodDeliveryThaiLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .styleInternationalCharacter(
            StarXpandCommand.Printer.InternationalCharacterType.Usa,
          )
          .styleCharacterSpace(0.0)
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .styleBold(true)
          .actionPrintText("สลิปการสั่งซื้อ\n")
          .styleBold(false)
          .actionPrintText("ร้าน STAR EAT  \n" + "Bangkok , Thailand \n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .actionPrintText("#0001\n"),
          )
          .actionPrintText(
            "วันที่:ดด/วว/ปปปป  เวลา:HH:MM PM\n" +
              "--------------------------------\n",
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
          .actionPrintText("ลูกค้า: ")
          .styleBold(true)
          .actionPrintText("Mr. Star Micronics \n")
          .styleBold(false)
          .actionPrintText(
            "ชำระเงินแล้ว \n" +
              "เวลาที่รับออเดอร์:HH:MM PM\n" +
              "--------------------------------\n" +
              "\n",
          )
          .actionPrintText(
            "1X ข้าวผัดปู           59 บาท \n" +
              "1X ต้มยำกุ้ง          120 บาท  \n" +
              "2X ก๋วยเตี๋ยวหมูน้ำตก    69 บาท \n" +
              "--------------------------------\n",
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
              .actionPrintText("**โปรดเตรียมช้อนส้อมให้ด้วย\n"),
          )
          .actionPrintText(
            "--------------------------------\n" + "รวม                       ",
          )
          .styleBold(true)
          .actionPrintText("248")
          .styleBold(false)
          .actionPrintText(
            "บาท\n" +
              "ภาษีมูลค่าเพิ่ม                - \n" +
              "--------------------------------\n",
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
              .styleBold(true)
              .actionPrintText("รวมทั้งหมด\n")
              .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
              .actionPrintText("248 บาท\n"),
          )
          .actionPrintText(
            "--------------------------------\n" +
              "\n" +
              "Charge " +
              "Visa XXXX-XXXX-XXXX-0123\n" +
              "\n",
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleInvert(true)
              .actionPrintText("การขอใบกำกับภาษี\n"),
          )
          .actionPrintText(
            "นี่ไม่ใช่ใบเสร็จรับเงินอย่างเป็นทางการ\n" +
              "และไม่สามารถใช้ในการคืนภาษีได้\n" +
              "โปรดขอใบกำกับภาษีอย่างเป็นทางการจากผู้ขาย\n" +
              "\n",
          )
          .actionFeedLine(1)
          .actionPrintQRCode(
            new StarXpandCommand.Printer.QRCodeParameter(
              "https://starmicronics.co.th/en/contact/\n",
            )
              .setModel(StarXpandCommand.Printer.QRCodeModel.Model2)
              .setLevel(StarXpandCommand.Printer.QRCodeLevel.L)
              .setCellSize(8),
          )
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
